/*
 * Permissions.h
 *
 *  Created on: 05.02.2010
 *      Author: stefan.detter
 */

#ifndef PERMISSIONS_H_
#define PERMISSIONS_H_

#include <QObject>
#include <QString>
#include <QSet>
#include <QMap>

class Permissions : public QObject
{
	Q_OBJECT

public:
	typedef enum {
		SHOW_WILDCARD_ALL_FIRMWARE_FILES,
		SHOW_WILDCARD_PUR_HID_KEYBOARD_FIRMWARE_FILES,
        SHOW_WILDCARD_PUR_IDTRONIC_RUSSIA_FIRMWARE_FILES,

		TRACE_ENABLED,
		READER_UPDATE_BOOTLOADER,

		READER_FREQUENCY_UNLIMITED,
		READER_ENGINEERING,
		READER_HIDDEN_SETTINGS,
		READER_LAB_FUNCTIONS,
		READER_ADVANCED_SETTINGS,
		READER_INTERFACE_SETTINGS,
        READER_RFP_SETTINGS,

		TAG_ENGINEERING,

	} PERMISSION_ID;

private:
	Permissions();

public:
	virtual ~Permissions();
	static Permissions* 	d;

	bool activatePermission ( const QString& password );

	bool traceEnabled();

	bool showWildcardAllFirmwareFiles();
	bool showWildcardPurHIDKeyboardFirmwareFiles();
    bool showWildcardPurIdtronicRussiaFirmwareFiles();

	bool readerUpdateBootloader();

	bool readerFrequencyUnlimited();

	bool readerAnyEngineering();
	bool readerEngineering ();
	bool readerLabFunctions();
	bool readerHiddenSettings();
    bool readerInterfaceSettings();
    bool readerReflectedPowerSettings();
    bool readerAdvancedSettings ();

	bool tagEngineering();

signals:
	void permissionsChanged();

private:
	static	Permissions		m_permissions;

	QSet<PERMISSION_ID>						m_permissionFlags;
	QMap<QString, QSet<PERMISSION_ID> >		m_passwords;
};


#endif /* PERMISSIONS_H_ */
